// Referenced Particles.js
//
// @author Hiroto Tsubaki / tg@tres-graficos.jp
// 
// 2014-04-20: initial release
//
// it's a Particle Script. To use, place this script into ~/Library/Application Support/Cheetah3D/Scripts/Particle folder.

function buildUI( obj ) {
  
  obj.setParameter("name", "Referenced Particles");
  
  obj.addParameterLink("reference", true);
  
  obj.addParameterFloat("attraction radius", 0.01, 0, 100, true, true);

  obj.addParameterSelector("mirror", [ "none", "ZY", "ZX", "YX" ], true, true);
  obj.addParameterButton("update", "update", "updateParticles");

  obj.addParameterBool("use mirrored", 0, 0, 1, true, true);

  obj.addParameterSeparator("Animation");
  
  obj.addParameterFloat("timer", 0, 0, 10000, true, true);
}

function updateParticles( obj ) {
  obj.update();
}

function buildObject( obj ) {
  var ref = obj.getParameter("reference");
  var mirror = obj.getParameter("mirror");
  var useMirrored = obj.getParameter("use mirrored");
  var radius = obj.getParameter("attraction radius");

  if (!ref) return;
  
  if (useMirrored) obj.setParameter("order", 2, false);
    
  var i, pos, rot, scale;
  var objs = [];
  
  var childCount = ref.childCount();
  
  if (childCount > 0) {
    for (var i = 0;i < childCount;i++) {
      var child = ref.childAtIndex(i);
      objs.push( child );
    }
  } else {
    objs.push( ref );
  }
  
  var core = obj.core();
  
  for (var i = 0;i < objs.length;i++) {
    var particlePoint = objs[i];
    
    pos = particlePoint.getParameter("position");
    rot = particlePoint.getParameter("rotation");
    scale = particlePoint.getParameter("scale");
    
    var particle = core.addParticle();
    
    particle.setPosition( pos );
    particle.setRotation( rot.convertEuler( ROT_HPB, ROT_XYZ ) );
    particle.setScale( scale );

    if (useMirrored) {
      particle.setIndex(0);
    }
  }
  
  if (mirror != 0) {
    for (var i = 0;i < objs.length;i++) {
      var particlePoint = objs[i];
      
      pos = particlePoint.getParameter("position");
      rot = particlePoint.getParameter("rotation");
      scale = particlePoint.getParameter("scale");
      
      var create = false;

      switch( mirror ) {
        case 1: // ZY
          if (Math.abs(pos.x) > radius) create = true;
          
          pos.x *= -1;
          if (!useMirrored) scale.x *= -1;
          rot.x *= -1;
          rot.z *= -1;
          break;
        case 2: // ZX
          if (Math.abs(pos.y) > radius) create = true;
          
          pos.y *= -1;
          if (!useMirrored) scale.y *= -1;
          rot.y *= -1;
          rot.z *= -1;
          break;
        case 3: // YX
          if (Math.abs(pos.z) > radius) create = true;

          pos.z *= -1;
          if (!useMirrored) scale.z *= -1;
          rot.x *= -1;
          rot.y *= -1;
          break;
      }
      
      if (create) {
        var particle = core.addParticle();

        particle.setPosition( pos );
        particle.setRotation( rot.convertEuler( ROT_HPB, ROT_ZYX ) );
        particle.setScale( scale );

        if (useMirrored) {
          particle.setIndex(1);
        }
      }
    }
  }
  
}